/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfDataTransfer;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.handlers.SdrUtils;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrHttpResponse;
import com.ibm.hwmca.base.rsf.requests.SdrRequestBody;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class SdrHandler
implements BaseRsfHandlersErrorIds,
BaseRsfDataTransfer {
    private static String TRACE_MASKF = "XRSFSDRF";
    private static String TRACE_MASKT = "XRSFSDRT";
    private static String TRACE_MASKD = "XRSFSDRD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "SdrHandler");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static MicrocodeLogAttributes infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
    private int response = 99;
    TcpConnection connection;
    private boolean canceled = false;
    private SdrRequestBody rsfRequestBody;
    private BaseRsfRequestImpl request;
    private BaseRsfResultDetails resultDetails = new BaseRsfResultDetails();

    public void requestCancelling() {
        this.setCanceled(true);
    }

    public BaseRsfResultDetails getResult() {
        return this.resultDetails;
    }

    public int transmit(TcpConnection tcpPath, RsfRequestBody requestBody, BaseRsfRequestImpl request) throws IOException {
        if (BaseRemoteSupportFacility.testRQ) {
            Trace.trace(TRACE_MASKF, "SdrHandler.transmit(): about to execute test wait");
            try {
                Thread.sleep(BaseRemoteSupportFacility.testWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "SdrHandler.transmit(): finished executing test wait");
            if (this.isCanceled()) {
                Trace.trace(TRACE_MASKF, "<- SdrHandler.transmit(): Canceled during test wait");
                return 99;
            }
        }
        Trace.trace(TRACE_MASKT, "-> SdrHandler::transmit()");
        try {
            this.rsfRequestBody = (SdrRequestBody)requestBody;
        }
        catch (ClassCastException e) {
            this.logInternalErrorAndContinue("SdrHandler.transmit(): wrong class type for request. Found " + this.rsfRequestBody.getClass().getName() + ".", e);
            this.resultDetails.setErrLogMsg("Invalid request class type.  Found " + this.rsfRequestBody.getClass().getName());
            Trace.trace(TRACE_MASKT, "<- SdrHandler::transmit()");
            return 999;
        }
        this.request = request;
        this.connection = tcpPath;
        int rc = this.doProcessing();
        Trace.trace(TRACE_MASKT, "<- SdrHandler::transmit");
        return rc;
    }

    private int doProcessing() throws IOException {
        int rc = 0;
        Trace.trace(TRACE_MASKT, "-> SdrHandler::doProcessing");
        SysInfo owningCredentials = this.request.getOwningCredentials();
        if (owningCredentials == null) {
            this.logInternalErrorAndContinue("No owning credentials", null);
            this.resultDetails.setErrLogMsg("Error: no owning credentials()");
            return 999;
        }
        SysInfo sendingCredentials = null;
        try {
            sendingCredentials = CredentialUtils.getLocalCredentials();
        }
        catch (Exception e) {
            HException exc = new HException(e);
            this.logErrorAndContinue("RetainUtils: getRetainToken: Exception getting local HMC credentials", exc, (short)28671);
            return 999;
        }
        if (sendingCredentials == null) {
            HException exc = new HException("RetainUtils getRetainToken found null local credentials");
            this.logErrorAndContinue("RetainUtils: getRetainToken: No local HMC credentials", exc, (short)28671);
            return 999;
        }
        ArrayList requestList = this.rsfRequestBody.getRequestList();
        ArrayList<SdrHttpResponse> responseList = new ArrayList<SdrHttpResponse>();
        RcsPath path = this.request.getPath();
        try {
            for (int i = 0; i < requestList.size(); ++i) {
                if (this.isCanceled()) {
                    Trace.trace(TRACE_MASKT, "<- SdrHandler::doTransfer already canceled");
                    return 99;
                }
                SdrHttpRequest httpRequest = (SdrHttpRequest)requestList.get(i);
                if (httpRequest == null) {
                    this.logErrorAndContinue("SdrHandler: SdrRequestBody list contains null SdrHttpRequest object", null, (short)28417);
                    this.resultDetails.getRsfResultDetails().putAttribute("error message", "Null SdrHttpRequest found");
                    return 90;
                }
                SdrHttpResponse httpResponse = null;
                httpResponse = SdrUtils.sendSdrRequest(path, this.connection, httpRequest, owningCredentials, sendingCredentials, this.resultDetails, this.request);
                responseList.add(i, httpResponse);
            }
        }
        catch (ClassCastException e) {
            this.logErrorAndContinue("SdrHandler: SdrRequestBody list contains non-SdrHttpRequest object", e, (short)28417);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String exceptionTrace = stringWriter.toString();
            this.resultDetails.getRsfResultDetails().putAttribute("error message", exceptionTrace);
            return 90;
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "SdrHandler: I/O Exception from sendSdrRequest");
            this.resultDetails.setReasonCode(1);
            throw e;
        }
        this.resultDetails.getRsfResultDetails().putAttribute("Sdr Responses", responseList);
        return rc;
    }

    synchronized void setCanceled(boolean cancel) {
        this.canceled = cancel;
    }

    synchronized boolean isCanceled() {
        return this.canceled;
    }

    private void logInternalErrorAndContinue(String errorMsg, Throwable t) {
        this.logErrorAndContinue(errorMsg, t, (short)28671);
    }

    private void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }
}

